<?php

class EWRporta_ControllerPublic_Thread extends XFCP_EWRporta_ControllerPublic_Thread
{
	public $perms;

	public function actionPromoteConfirm()
	{
		if (!$this->perms['promote']) { return $this->responseNoPermission(); }

		$ftpHelper = $this->getHelper('ForumThreadPost');

		$threadId = $this->_input->filterSingle('thread_id', XenForo_Input::UINT);
		list($thread, $forum) = $ftpHelper->assertThreadValidAndViewable($threadId);

		$threadPromote = $this->getModelFromCache('EWRporta_Model_Promotes')->getPromoteByThreadId($thread['thread_id']);

		$datetime = $threadPromote ? $threadPromote['promote_date'] : XenForo_Application::$time;
		$datetime = date('n.j.Y.h.i.a.T', $datetime);
		$datetime = explode('.', $datetime);

		$datetime = array(
			'month' => $datetime[0],
			'day' => $datetime[1],
			'year' => $datetime[2],
			'hour' => $datetime[3],
			'minute' => $datetime[4],
			'ampm' => $datetime[5],
			'zone' => $datetime[6]
		);

		$months = array();
		$days = array();
		$hours = array();
		$minutes = array();

		for($i = 1; $i <= 12; $i++)
		{
			$months[] = array(
				'number' => $i,
				'select' => $i == $datetime['month'] ? true : false,
				'phrase' => new XenForo_Phrase('month_'.$i),
			);
		}

		$viewParams = array(
			'thread' => $thread,
			'threadPromote' => $threadPromote,
			'datetime' => $datetime,
			'months' => $months,
			'nodeBreadCrumbs' => $ftpHelper->getNodeBreadCrumbs($forum),
		);

		return $this->responseView('XenForo_ViewPublic_Thread_Watch', 'EWRporta_Promote', $viewParams);
	}

	public function actionPromote()
	{
		if (!$this->perms['promote']) { return $this->responseNoPermission(); }

		$ftpHelper = $this->getHelper('ForumThreadPost');

		$input = $this->_input->filter(array(
			'thread_id' => XenForo_Input::UINT,
			'promote_date' => XenForo_Input::UINT,
			'month' => XenForo_Input::UINT,
			'day' => XenForo_Input::UINT,
			'year' => XenForo_Input::UINT,
			'hour' => XenForo_Input::UINT,
			'minute' => XenForo_Input::UINT,
			'ampm' => XenForo_Input::STRING,
			'delete' => XenForo_Input::STRING,
		));

		list($thread, $forum) = $ftpHelper->assertThreadValidAndViewable($input['thread_id']);

		$this->getModelFromCache('EWRporta_Model_Promotes')->updatePromotion($input);
		$this->getModelFromCache('EWRporta_Model_Cache')->emptyModuleCache(array('module_name'=>'RecentNews'));

		return $this->responseRedirect(
			XenForo_ControllerResponse_Redirect::SUCCESS,
			XenForo_Link::buildPublicLink('threads', $thread),
			null,
			array('linkPhrase' => '<span>'.($input['delete'] ? new XenForo_Phrase('promote_thread') : new XenForo_Phrase('promote_options')).'</span>')
		);
	}

	public function _preDispatch($action)
	{
		parent::_preDispatch($action);

		$this->perms = $this->getModelFromCache('EWRporta_Model_Perms')->getPermissions();
	}
}